<?php
// ==========================================
//      FINAL ADVANCED BOT (Crash Proof)
// ==========================================

// 1. Error Handling (Log errors, don't show them to user)
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', 'bot_errors.log');
date_default_timezone_set('Asia/Kolkata');

// --- CONFIGURATION ---
$botToken = "8305712569:AAEVonCdz1Wx8zGl-5Hvwpk8bLK-fasT_VE"; // यहाँ अपना टोकन डालें
$website = "https://api.telegram.org/bot" . $botToken;

// Admin IDs (Comma separated)
$adminIds = ["8427084594", "5482954908"]; 

// Payment UPI
$upiId = "8360626185@naviaxis";

// --- API SERVICES ---
$services = [
    'srv_pan' => [
        'name' => '💳 Pan Details',
        'cost' => 5,
        'url' => 'https://smartbot.in.net/verification-open-api/pan-verification/pan-detail-two-api.php',
        'param' => 'pan_number',
        'req' => 'Please enter PAN Number:'
    ],
    'srv_rc' => [
        'name' => '🚗 RC Details',
        'cost' => 5,
        'url' => 'https://smartbot.in.net/verification-open-api/rc-verification/rc-details.php',
        'param' => 'registrationNumber',
        'req' => 'Enter Vehicle No (DL01AB1234):'
    ],
    'srv_ration' => [
        'name' => '🍚 Ration Card',
        'cost' => 5,
        'url' => 'https://smartbot.in.net/verification-open-api/get-rationcard/get-rationcard-details.php',
        'param' => 'rationcard_number',
        'req' => 'Please enter Ration Card No:'
    ],
    'srv_mob' => [
        'name' => '📱 Mobile Details',
        'cost' => 5,
        'url' => 'https://smartbot.in.net/verification-open-api/mobile-to-details/mobiledetails.php',
        'param' => 'num',
        'req' => 'Enter 10-digit Mobile No:'
    ],
    'srv_challan' => [
        'name' => '🚔 Vehicle Challan',
        'cost' => 5,
        'url' => 'https://secureapi.in.net/vehicleinfo/challan_api.php',
        'param' => 'vehicle_number',
        'req' => 'Enter Vehicle No for Challan:'
    ],
    'srv_rc_full' => [
        'name' => '🚛 RC Full Details',
        'cost' => 10, // Special Price
        'url' => 'https://smartbot.in.net/verification-open-api/rc-verification/rc-full-details.php',
        'param' => 'registrationNumber',
        'req' => 'Enter Vehicle No for Full Details:'
    ],
    'srv_m_name' => [
        'name' => '👤 Mobile to Name',
        'cost' => 5,
        'url' => 'https://smartbot.in.net/verification-open-api/mobile-to-details/mobile-to-name.php',
        'param' => 'num',
        'req' => 'Enter Mobile No to find Name:'
    ],
    'srv_m_addr' => [
        'name' => '📍 Mobile to Address',
        'cost' => 5,
        'url' => 'https://smartbot.in.net/verification-open-api/mobile-to-details/mobile_to_address.php',
        'param' => 'num',
        'req' => 'Enter Mobile No to find Address:'
    ],
    'srv_m_uid' => [
        'name' => '🔢 Mobile to Aadhaar',
        'cost' => 5,
        'url' => 'https://smartbot.in.net/verification-open-api/mobile-to-details/mobile_to_aadhar.php',
        'param' => 'num',
        'req' => 'Enter Mobile No to find Aadhaar:'
    ]
];

// --- BROWSER CHECK ---
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    echo "<h1>Bot is Active ✅</h1>";
    exit;
}

// --- MAIN LOGIC ---
$content = file_get_contents("php://input");
$update = json_decode($content, TRUE);

if (!$update) exit;

// A. CALLBACK QUERY (Buttons)
if (isset($update["callback_query"])) {
    $chatId = $update["callback_query"]["message"]["chat"]["id"];
    $data = $update["callback_query"]["data"];
    $qid = $update["callback_query"]["id"];

    // Stop Loading
    sendRequest('answerCallbackQuery', ['callback_query_id' => $qid]);

    try {
        if ($data == "home") {
            clearState($chatId);
            sendMainMenu($chatId);
        }
        elseif ($data == "my_profile") {
            sendProfile($chatId);
        }
        elseif ($data == "add_fund") {
            sendPaymentQR($chatId);
        }
        elseif (array_key_exists($data, $services)) {
            $svc = $services[$data];
            $bal = getPoints($chatId);

            if ($bal < $svc['cost']) {
                sendMessage($chatId, "❌ **Insufficient Points!**\nRequired: {$svc['cost']}\nAvailable: $bal\n\nPlease Add Points.");
            } else {
                saveState($chatId, ['step' => 'wait_input', 'svc_id' => $data]);
                sendMessage($chatId, "✅ **Selected:** " . $svc['name'] . "\n💰 **Cost:** " . $svc['cost'] . " Pts\n\n👇 " . $svc['req']);
            }
        }
    } catch (Exception $e) {
        // Silent Fail
    }
}

// B. MESSAGES
if (isset($update["message"])) {
    $chatId = $update["message"]["chat"]["id"];
    $text = $update["message"]["text"] ?? '';
    $user = $update["message"]["from"];

    // Init User
    initUser($chatId, $user['first_name'] ?? 'User');

    if ($text == "/start") {
        clearState($chatId);
        sendMainMenu($chatId);
    }
    elseif (strpos($text, "/add") === 0 && in_array($chatId, $adminIds)) {
        // ADMIN COMMAND
        $p = explode(" ", $text);
        if (count($p) == 3) {
            addPoints($p[1], (int)$p[2]);
            sendMessage($chatId, "✅ Points added to {$p[1]}");
            sendMessage($p[1], "🥳 **Points Added!**\nAdmin credited {$p[2]} points.");
        }
    }
    else {
        $state = getState($chatId);
        
        if ($state) {
            // 1. API INPUT
            if ($state['step'] == 'wait_input') {
                $svcId = $state['svc_id'];
                $svc = $services[$svcId];
                
                if (getPoints($chatId) < $svc['cost']) {
                    sendMessage($chatId, "❌ Low Balance.");
                    clearState($chatId);
                    return;
                }

                sendMessage($chatId, "⏳ **Checking...** Please wait.");

                $apiUrl = $svc['url'] . "?" . $svc['param'] . "=" . urlencode(trim($text));
                $res = fetchApi($apiUrl);

                if ($res) {
                    $newBal = deductPoints($chatId, $svc['cost']);
                    $msg = "✅ **Found!** (Bal: $newBal)\n";
                    $msg .= "🔧 " . $svc['name'] . "\n";
                    $msg .= "➖➖➖➖➖➖➖➖\n";
                    $msg .= formatJson($res);
                    sendMessage($chatId, $msg);
                } else {
                    sendMessage($chatId, "❌ **No Data Found** or API Error.");
                }
                clearState($chatId);
            }
            // 2. UTR INPUT
            elseif ($state['step'] == 'wait_utr') {
                sendMessage($chatId, "✅ **UTR Sent!** Wait for verification.");
                foreach ($adminIds as $admin) {
                    sendMessage($admin, "🔔 **Payment Alert**\nUser: `$chatId`\nUTR: `$text`\nUse: `/add $chatId <amount>`");
                }
                clearState($chatId);
            }
        }
    }
}

// --- FUNCTIONS ---
function fetchApi($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    $res = curl_exec($ch);
    curl_close($ch);
    $json = json_decode($res, true);
    return $json; 
}

function formatJson($data, $i = "") {
    $out = "";
    if (!is_array($data)) return $data . "\n";
    foreach ($data as $k => $v) {
        if (is_array($v)) $out .= "\n🔹 *" . strtoupper($k) . "*:\n" . formatJson($v, "  ");
        else $out .= $i . "🔸 " . ucfirst($k) . ": `$v`\n";
    }
    return $out;
}

// DATABASE (With Error Checks)
function initUser($uid, $name) {
    $db = getDb('users.json');
    if (!isset($db[$uid])) {
        $db[$uid] = ['pts' => 10, 'name' => $name]; 
        saveDb('users.json', $db);
    }
}

function getPoints($uid) {
    $db = getDb('users.json');
    return $db[$uid]['pts'] ?? 0;
}

function deductPoints($uid, $amt) {
    $db = getDb('users.json');
    if (isset($db[$uid])) {
        $db[$uid]['pts'] = max(0, $db[$uid]['pts'] - $amt);
        saveDb('users.json', $db);
        return $db[$uid]['pts'];
    }
    return 0;
}

function addPoints($uid, $amt) {
    $db = getDb('users.json');
    if (!isset($db[$uid])) $db[$uid] = ['pts' => 0];
    $db[$uid]['pts'] += $amt;
    saveDb('users.json', $db);
}

function getDb($file) {
    if (!file_exists($file)) return [];
    $content = file_get_contents($file);
    return json_decode($content, true) ?: [];
}

function saveDb($file, $data) {
    file_put_contents($file, json_encode($data));
}

// STATE
function saveState($uid, $data) {
    $db = getDb('states.json');
    $db[$uid] = $data;
    saveDb('states.json', $db);
}

function getState($uid) {
    $db = getDb('states.json');
    return $db[$uid] ?? null;
}

function clearState($uid) {
    $db = getDb('states.json');
    unset($db[$uid]);
    saveDb('states.json', $db);
}

// TELEGRAM
function sendMainMenu($chatId) {
    global $services;
    $bal = getPoints($chatId);
    $txt = "🤖 *Verification Bot*\n💰 Points: *$bal*\n👇 Select Service:";
    $kb = ['inline_keyboard' => []];
    $row = []; $c = 0;
    foreach ($services as $k => $v) {
        $row[] = ['text' => $v['name'], 'callback_data' => $k];
        $c++;
        if ($c % 2 == 0) { $kb['inline_keyboard'][] = $row; $row = []; }
    }
    if ($row) $kb['inline_keyboard'][] = $row;
    $kb['inline_keyboard'][] = [['text' => '➕ Add Points', 'callback_data' => 'add_fund'], ['text' => '👤 Profile', 'callback_data' => 'my_profile']];
    sendMessage($chatId, $txt, $kb);
}

function sendPaymentQR($chatId) {
    global $upiId;
    $url = "https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=" . urlencode("upi://pay?pa=$upiId&pn=Service&cu=INR");
    saveState($chatId, ['step' => 'wait_utr']);
    sendRequest('sendPhoto', ['chat_id' => $chatId, 'photo' => $url, 'caption' => "Scan & Pay\nThen send **UTR Number** below:", 'reply_markup' => json_encode(['inline_keyboard' => [[['text'=>'Cancel','callback_data'=>'home']]]])]);
}

function sendProfile($chatId) {
    $p = getPoints($chatId);
    sendMessage($chatId, "👤 ID: `$chatId`\n💰 Points: *$p*", ['inline_keyboard' => [[['text'=>'Back','callback_data'=>'home']]]]);
}

function sendMessage($chatId, $txt, $kb = null) {
    sendRequest('sendMessage', ['chat_id' => $chatId, 'text' => $txt, 'parse_mode' => 'Markdown', 'reply_markup' => $kb ? json_encode($kb) : null]);
}

function sendRequest($m, $d) {
    global $website;
    $ch = curl_init($website . "/" . $m);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $d);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $r = curl_exec($ch);
    curl_close($ch);
    return $r;
}
?>
